/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityInventoryWrapper<T extends BlockEntity>
implements Container {
    private final T wrapped;
    private final AbstractContainerMenu menu;

    public BlockEntityInventoryWrapper(T wrapped, AbstractContainerMenu menu) {
        this.wrapped = wrapped;
        this.menu = menu;
    }

    public void clearContent() {
        ((Clearable)this.wrapped).clearContent();
        this.menu.slotsChanged((Container)this.wrapped);
    }

    public int getContainerSize() {
        return ((Container)this.wrapped).getContainerSize();
    }

    public boolean isEmpty() {
        return ((Container)this.wrapped).isEmpty();
    }

    public ItemStack getItem(int index) {
        return ((Container)this.wrapped).getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack toReturn = ((Container)this.wrapped).removeItem(index, count);
        this.menu.slotsChanged((Container)this.wrapped);
        return toReturn;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack toReturn = ((Container)this.wrapped).removeItemNoUpdate(index);
        this.menu.slotsChanged((Container)this.wrapped);
        return toReturn;
    }

    public void setItem(int index, ItemStack stack) {
        ((Container)this.wrapped).setItem(index, stack);
        this.menu.slotsChanged((Container)this.wrapped);
    }

    public void setChanged() {
        this.wrapped.setChanged();
        this.menu.slotsChanged((Container)this.wrapped);
    }

    public boolean stillValid(Player player) {
        return ((Container)this.wrapped).stillValid(player);
    }
}

